<?php
require_once 'config.php';
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $name = $_POST['name'] ?? '';
    $type = $_POST['type'] ?? '';
    $location = $_POST['location'] ?? '';
    $link = !empty($_POST['link']) ? $_POST['link'] : null;
    $description = !empty($_POST['description']) ? $_POST['description'] : null;
    $image_path = null;

    if(isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK){
        $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','webp','gif'];
        if(in_array($ext, $allowed)){
            if(!is_dir('uploads')) mkdir('uploads',0755,true);
            $filename = 'uploads/' . time() . '_' . bin2hex(random_bytes(5)) . '.' . $ext;
            move_uploaded_file($_FILES['image']['tmp_name'], $filename);
            $image_path = $filename;
        }
    }

    $stmt = $conn->prepare("INSERT INTO projects (name,type,location,description,image,link) VALUES (?,?,?,?,?,?)");
    $stmt->bind_param("ssssss", $name, $type, $location, $description, $image_path, $link);
    $stmt->execute();
    $stmt->close();
}

header("Location: index.php");
exit;
