<?php
// index.php (نسخه بازنویسی شده — شامل نقشه Leaflet و گرید کارت‌ها)
// نکته: اگر از config.php استفاده می‌کنی، آن را require کن.
// require_once 'config.php';

ini_set('display_errors', 1);
error_reporting(E_ALL);

// اتصال سریع به دیتابیس اگر config ندارید (روی لوکال پیش‌فرض)
$DB_HOST = 'localhost';
$DB_USER = 'root';
$DB_PASS = '';
$DB_NAME = 'omid_projects';
$conn = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
if ($conn->connect_error) {
    die("DB connection error: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4");

session_start();

// گرفتن پروژه‌ها
$stmt = $conn->prepare("SELECT * FROM projects ORDER BY created_at DESC");
$stmt->execute();
$result = $stmt->get_result();
?>
<!doctype html>
<html lang="fa">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>پروژه‌های امیدبخش جامعه</title>

<!-- Bootstrap RTL (اختیاری) -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">

<!-- استایل اختصاصی (فرض: style.css در مسیر قرار دارد) -->
<link rel="stylesheet" href="style.css">

<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css"/>

<style>
/* اگر خواستی چند اصلاح سریع محلی اینجا هم بذار */
body { background:#f6f7f8; }
</style>
</head>
<body>

<a href="admin/login.php" class="admin-login-btn">ورود مدیر</a>

<header>
  <h1 class="text-center">پروژه‌های امیدبخش جامعه</h1>
</header>

<div class="intro">
  به جمع پروژه‌های امیدبخش بپیوندید — پروژه‌تان را ثبت کنید تا دیگران هم از آن مطلع شوند.
</div>

<!-- پروژه‌ها -->
<div class="project-grid" id="projects">
  <?php while($row = $result->fetch_assoc()):
      // مسیر تصویر — اگر NULL یا خالی باشه default نمایش داده میشه
      $img = !empty($row['image']) ? $row['image'] : 'uploads/default.png';
      // امن‌سازی خروجی
      $name = htmlspecialchars($row['name']);
      $type = htmlspecialchars($row['type']);
      $location = htmlspecialchars($row['location']);
      $desc = !empty($row['description']) ? htmlspecialchars(mb_substr($row['description'],0,140)) : 'توضیحی ثبت نشده';
  ?>
  <div class="project-card">
    <img src="<?php echo $img; ?>" alt="<?php echo $name; ?>" class="p-img" onerror="this.src='uploads/default.png'">
    <h3><?php echo $name; ?></h3>
    <div class="p-meta"><?php echo $location . ' • ' . $type; ?></div>
    <div class="p-desc"><?php echo $desc; ?></div>

    <div class="card-actions">
      <?php if(!empty($row['link'])): ?>
        <a class="p-btn" href="<?php echo htmlspecialchars($row['link']); ?>" target="_blank" rel="noopener">مشاهده</a>
      <?php else: ?>
        <span class="p-btn" style="opacity:.6">مشاهده</span>
      <?php endif; ?>

      <!-- فقط برای مدیر، دکمه‌های مدیریت نمایش داده شود -->
      <?php if(isset($_SESSION['admin'])): ?>
        <div class="admin-actions">
          <a class="edit" href="admin/edit.php?id=<?php echo $row['id']; ?>">ویرایش</a>
          <a class="delete" href="admin/delete.php?id=<?php echo $row['id']; ?>" onclick="return confirm('آیا مطمئن هستید؟')">حذف</a>
        </div>
      <?php endif; ?>
    </div>
  </div>
  <?php endwhile; ?>
</div>

<!-- فرم ارسال پروژه -->
<div class="submit-project">
  <form action="submit_project.php" method="POST" enctype="multipart/form-data">
    <input name="name" type="text" placeholder="نام پروژه" required>
    <input name="type" type="text" placeholder="نوع پروژه (مثلاً: آموزشی)" required>
    <input name="location" type="text" placeholder="محل اجرا" required>
    <input name="link" type="text" placeholder="لینک (اختیاری)">
    <textarea name="description" placeholder="توضیح کوتاه (اختیاری)"></textarea>
    <input name="image" type="file" accept="image/*">
    <button type="submit">ارسال پروژه</button>
  </form>
</div>

<!-- نقشه (Leaflet) -->
<div style="max-width:1100px;margin:20px auto;">
  <div id="map" style="height:380px;border-radius:10px;border:1px solid #e6e7e8;"></div>
</div>

<div class="footer-note">© تمام حقوق محفوظ است — امید فردا</div>

<!-- اسکریپت‌ها -->
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
<script>
  // ساخت نقشه
  var map = L.map('map').setView([32.0, 53.0], 5);
  L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
      maxZoom: 19,
      attribution: '© OpenStreetMap'
  }).addTo(map);

  // بارگذاری پروژه‌ها برای نقشه از PHP (با توجه به latitude/longitude)
  var projects = [
    <?php
    // query دوباره برای مختصات
    $res_map = $conn->query("SELECT name,latitude,longitude FROM projects WHERE latitude IS NOT NULL AND longitude IS NOT NULL");
    while($r = $res_map->fetch_assoc()){
        $jsname = addslashes($r['name']);
        $lat = $r['latitude']+0;
        $lng = $r['longitude']+0;
        if($lat && $lng) echo "{name: '{$jsname}', lat: {$lat}, lng: {$lng}},";
    }
    ?>
  ];

  projects.forEach(function(p){
    if(p.lat && p.lng){
      L.marker([p.lat, p.lng]).addTo(map).bindPopup('<b>'+p.name+'</b>');
    }
  });
</script>

</body>
</html>
