<?php
session_start();
require_once '../config.php';
if(!isset($_SESSION['admin'])){ header("Location: login.php"); exit; }

// آمار
$res_total = $conn->query("SELECT COUNT(*) as total FROM projects");
$total = $res_total->fetch_assoc()['total'];

// پروژه‌ها (لیست)
$stmt = $conn->prepare("SELECT * FROM projects ORDER BY created_at DESC");
$stmt->execute();
$res = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>داشبورد مدیریت</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<link rel="stylesheet" href="../style.css">
</head>
<body>
<div class="container" style="max-width:1200px;">
  <div class="d-flex justify-content-between align-items-center mt-4 mb-3">
    <h2>داشبورد مدیریت</h2>
    <div>
      <a href="add.php" class="btn btn-outline-primary me-2">افزودن پروژه</a>
      <a href="logout.php" class="btn btn-outline-secondary">خروج</a>
    </div>
  </div>

  <div class="row mb-3">
    <div class="col-12 col-md-4">
      <div class="glass-box text-center p-3">
        <h5>کل پروژه‌ها</h5>
        <p class="fs-3 mb-0"><?php echo $total; ?></p>
      </div>
    </div>
  </div>

  <div class="glass-box p-3">
    <h5>لیست پروژه‌ها</h5>
    <div class="project-grid">
      <?php while($row = $res->fetch_assoc()):
        $img = !empty($row['image']) ? $row['image'] : '../uploads/default.png';
      ?>
      <div class="project-card">
        <img src="<?php echo htmlspecialchars($img); ?>" class="p-img" onerror="this.src='../uploads/default.png'">
        <h3><?php echo htmlspecialchars($row['name']); ?></h3>
        <div class="p-meta"><?php echo htmlspecialchars($row['location']).' • '.htmlspecialchars($row['type']); ?></div>
        <div class="p-desc"><?php echo !empty($row['description']) ? htmlspecialchars(mb_substr($row['description'],0,120)) : 'ندارد'; ?></div>
        <div class="card-actions">
          <?php if(!empty($row['link'])): ?><a class="p-btn" href="<?php echo htmlspecialchars($row['link']); ?>" target="_blank">مشاهده</a><?php else: ?><span class="p-btn" style="opacity:.6">مشاهده</span><?php endif; ?>
          <div class="admin-actions">
            <a class="edit" href="edit.php?id=<?php echo $row['id']; ?>">ویرایش</a>
            <a class="delete" href="delete.php?id=<?php echo $row['id']; ?>" onclick="return confirm('آیا مطمئن هستید؟')">حذف</a>
          </div>
        </div>
      </div>
      <?php endwhile; ?>
    </div>
  </div>
</div>

<!-- bootstrap js -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
