<?php
session_start();
require_once '../config.php';
if(!isset($_SESSION['admin'])){ header("Location: login.php"); exit; }

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $name = $_POST['name'] ?? '';
    $type = $_POST['type'] ?? '';
    $location = $_POST['location'] ?? '';
    $link = !empty($_POST['link']) ? $_POST['link'] : null;
    $description = !empty($_POST['description']) ? $_POST['description'] : null;
    $image_path = null;

    if(isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK){
        $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','webp','gif'];
        if(in_array($ext,$allowed)){
            if(!is_dir('../uploads')) mkdir('../uploads',0755,true);
            $filename = '../uploads/' . time() . '_' . bin2hex(random_bytes(5)) . '.' . $ext;
            move_uploaded_file($_FILES['image']['tmp_name'],$filename);
            $image_path = substr($filename,3); // store relative path uploads/...
        }
    }

    $stmt = $conn->prepare("INSERT INTO projects (name,type,location,description,image,link) VALUES (?,?,?,?,?,?)");
    $stmt->bind_param("ssssss",$name,$type,$location,$description,$image_path,$link);
    $stmt->execute();
    header("Location: dashboard.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="fa">
<head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>افزودن پروژه</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<link rel="stylesheet" href="../style.css">
</head>
<body>
<div class="container" style="max-width:900px;margin-top:20px">
  <div class="glass-box p-3">
    <h4>افزودن پروژه جدید</h4>
    <form method="post" enctype="multipart/form-data">
      <input name="name" class="form-control mb-2" placeholder="نام پروژه" required>
      <input name="type" class="form-control mb-2" placeholder="نوع پروژه" required>
      <input name="location" class="form-control mb-2" placeholder="محل اجرا" required>
      <input name="link" class="form-control mb-2" placeholder="لینک (اختیاری)">
      <textarea name="description" class="form-control mb-2" placeholder="توضیح"></textarea>
      <input name="image" type="file" class="form-control mb-2" accept="image/*">
      <button class="btn btn-dark">افزودن</button>
      <a href="dashboard.php" class="btn btn-link">بازگشت</a>
    </form>
  </div>
</div>
</body>
</html>
