<?php
// admin/edit.php – نسخه کامل و امن
session_start();
require_once '../config.php'; // مسیر config

// بررسی لاگین ادمین
if(!isset($_SESSION['admin'])){
    header("Location: login.php");
    exit;
}

// گرفتن id و اعتبارسنجی
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if($id <= 0){
    die("شناسه پروژه معتبر نیست.");
}

// گرفتن اطلاعات پروژه از دیتابیس
$stmt = $conn->prepare("SELECT * FROM projects WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();
$project = $res->fetch_assoc();
$stmt->close();

if(!$project){
    die("پروژه‌ای با این شناسه پیدا نشد.");
}

// تابع امن برای چاپ مقادیر فرم
function safe($v){
    return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8');
}

// پردازش فرم ارسال (POST)
if($_SERVER['REQUEST_METHOD'] === 'POST'){

    // گرفتن و پاکسازی ورودی‌ها
    $name = isset($_POST['name']) ? $conn->real_escape_string(trim($_POST['name'])) : $project['name'];
    $type = isset($_POST['type']) ? $conn->real_escape_string(trim($_POST['type'])) : $project['type'];
    $location = isset($_POST['location']) ? $conn->real_escape_string(trim($_POST['location'])) : $project['location'];
    $link = isset($_POST['link']) ? $conn->real_escape_string(trim($_POST['link'])) : $project['link'];
    $description = isset($_POST['description']) ? $conn->real_escape_string(trim($_POST['description'])) : $project['description'];

    // مسیر تصویر فعلی
    $image_path = $project['image'];

    // بررسی و آپلود تصویر جدید
    if(isset($_FILES['image']) && isset($_FILES['image']['tmp_name']) && is_uploaded_file($_FILES['image']['tmp_name'])){
        $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','webp','gif'];
        if(in_array($ext, $allowed)){
            $uploadsDir = __DIR__ . '/../uploads';
            if(!is_dir($uploadsDir)){
                mkdir($uploadsDir, 0755, true);
            }
            $newFilename = 'uploads/' . time() . '_' . bin2hex(random_bytes(6)) . '.' . $ext;
            $moveTo = __DIR__ . '/../' . $newFilename;
            if(move_uploaded_file($_FILES['image']['tmp_name'], $moveTo)){
                if(!empty($project['image'])){
                    $oldPath = __DIR__ . '/../' . $project['image'];
                    if(file_exists($oldPath)){
                        @unlink($oldPath);
                    }
                }
                $image_path = $newFilename;
            } else {
                $uploadError = "بارگذاری تصویر ناموفق بود.";
            }
        } else {
            $uploadError = "فرمت تصویر معتبر نیست. فقط jpg, png, webp, gif مجازند.";
        }
    }

    // بروزرسانی امن در دیتابیس
    $stmt2 = $conn->prepare("UPDATE projects SET name=?, type=?, location=?, description=?, image=?, link=? WHERE id=?");
    if(!$stmt2){
        die("خطای آماده‌سازی پرس‌وجو: " . $conn->error);
    }
    $stmt2->bind_param("ssssssi", $name, $type, $location, $description, $image_path, $link, $id);
    if(!$stmt2->execute()){
        $stmt2->close();
        die("خطا در به‌روزرسانی: " . $conn->error);
    }
    $stmt2->close();

    // موفقیت — بازگشت به داشبورد
    header("Location: dashboard.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>ویرایش پروژه</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<link rel="stylesheet" href="../style.css">
<style>
    body { background-color: #f8f9fa; }
    .glass-box { background: rgba(255,255,255,0.95); border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); }
</style>
</head>
<body>
<div class="container" style="max-width:900px;margin-top:24px;">
  <div class="glass-box p-4">
    <h3 class="mb-3">ویرایش پروژه</h3>

    <?php if(!empty($uploadError)): ?>
      <div class="alert alert-warning"><?php echo safe($uploadError); ?></div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data">
      <div class="mb-3">
        <label class="form-label">نام پروژه</label>
        <input name="name" class="form-control" value="<?php echo safe($project['name']); ?>" required>
      </div>

      <div class="mb-3">
        <label class="form-label">نوع پروژه</label>
        <input name="type" class="form-control" value="<?php echo safe($project['type']); ?>" required>
      </div>

      <div class="mb-3">
        <label class="form-label">محل اجرا</label>
        <input name="location" class="form-control" value="<?php echo safe($project['location']); ?>">
      </div>

      <div class="mb-3">
        <label class="form-label">لینک (اختیاری)</label>
        <input name="link" class="form-control" value="<?php echo safe($project['link']); ?>">
      </div>

      <div class="mb-3">
        <label class="form-label">توضیحات</label>
        <textarea name="description" class="form-control"><?php echo safe($project['description']); ?></textarea>
      </div>

      <div class="mb-3">
        <label class="form-label">تصویر فعلی</label><br>
        <img src="../<?php echo !empty($project['image']) ? safe($project['image']) : 'uploads/default.png'; ?>" 
             alt="تصویر پروژه" width="220" onerror="this.src='../uploads/default.png'">
      </div>

      <div class="mb-3">
        <label class="form-label">آپلود تصویر جدید (اختیاری)</label>
        <input type="file" name="image" accept="image/*" class="form-control">
      </div>

      <div class="d-flex gap-2">
        <button class="btn btn-dark" type="submit">ثبت تغییرات</button>
        <a href="dashboard.php" class="btn btn-link">انصراف</a>
      </div>
    </form>
  </div>
</div>
</body>
</html>
